## Read in data including indicator for whether bequest is likely from partner death


# Preliminaries -----------------------------------------------------------

rm(list=ls())
gc()

memory.limit(size=25000)


# Master package loading
source("./R scripts/Master package loading.R", encoding="ISO-8859-1")

## location of bequest data - generated separately in Stata
bequest_path <- "./first_estate_bequest.dta"

## where to save bequest data
hilda_qs_path <- "./HILDA Wave 19/qs files/"


# Read in data ------------------------------------------------------------\

bequests <- read_dta(bequest_path)


# Save as qs file --------------------------------------------------------

qsave(bequests, paste0(hilda_qs_path, "first_estate_bequest_id.qs"))
